/**********
* File: CDGL_IDirect3DVertexDeclaration9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DVertexDeclaration9. 
					 This class is the concrete implementation of IDirect3DVertexDeclaration9 interface. The IDirect3DVertexDeclaration9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 17Mar05

* Change History (Most Recent First):

**********/

#ifndef __CDGL_IDIRECT3DVERTEXDECLARATION_H__
#define __CDGL_IDIRECT3DVERTEXDECLARATION_H__

#include <Carbon/Carbon.h>
#include "d3d9.h"

class CDGL_IDirect3DVertexDeclaration9 : public IDirect3DVertexDeclaration9
{
	public:
		CDGL_IDirect3DVertexDeclaration9(IDirect3DDevice9* in_pDevice);
		~CDGL_IDirect3DVertexDeclaration9();
		
		/*** IUnknown methods ***/
		HRESULT QueryInterface( REFIID riid, void** ppvObj);
		ULONG AddRef();
		ULONG Release();

		/*** IDirect3DVertexDeclaration9 methods ***/
		HRESULT GetDevice( IDirect3DDevice9** ppDevice);
		HRESULT GetDeclaration( D3DVERTEXELEMENT9*,UINT* pNumElements);
	
	
		// | ≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈  Additional methods  ≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈ |
		void	AddElements(CONST D3DVERTEXELEMENT9 *);
	
	private:
		IDirect3DDevice9 *		m_pDevice;
		int						m_lRefCount;
		D3DVERTEXELEMENT9 *		mVertexElements;
		int						mNumVertexElements;
	
};


#endif //__CDGL_IDIRECT3DVERTEXDECLARATION_H__
